#!/usr/bin/perl
# 
# WIDE InternetFAX
#      Message Dispatcher
#
# file: ifax_dispatcher.pl
# 
# Written by Masahiko KIMOTO <kimoto@ohnolab.org>.
# Copyright (c) 1998 by Masahiko KIMOTO <kimoto@ohnolab.org>,
#                       Ohno Laboratory(Tokyo Institute of Technology),
#                       WIDE Project.
# ALL RIGHTS RESERVED.
#
# If you need fully defined copyright notice, see COPYRIGHT which is 
# included in this package.
# 
# $Id: ifax_dispatcher.pl,v 1.5 1999/03/08 04:22:57 kimoto Exp $

# ---------------------------------------------------------------------------
# DESCRIPTION OF THIS FILE:
# ȤͿ줿סǥ쥯ȥľˤإåե
# (ե̾ header )Ƥ򻲾Ȥ롼ǡ١˴Ť
# Ŭڤ֥⥸塼¹Ԥ롣
# ܺ٤README.ifax_dispatcher.pl.jp򻲾ȤΤ
# ---------------------------------------------------------------------------

# ---------------------------------------------------------------------------
#  եɤ߹ࡣ
# ---------------------------------------------------------------------------
# ɸեpath/etc/wifax.confĶѿ
# WIFAXCONFPATHͤǾ񤭤Ǥ롣
# եƤ KEY = VAL ηǤФȤꤢʤǤ
# ŪKEYιܤϷƤ
# ޤKEYʸʸ̵뤹롣
# rulefile: dispatcherѤ롼ǡ١Υե̾
# bindir:   ٤ƤΥ⥸塼μ¹Է֤Ƥǥ쥯ȥ̾
# spooldir: סΥǥ쥯ȥ̾
#
$wifax_conf = "/etc/wifax.conf";
$wifax_conf = $ENV{'WIFAXCONFPATH'} if ($ENV{'WIFAXCONFPATH'} ne "");
undef %CONFIG;
if (-e $wifax_conf) {
    open(CONF,$wifax_conf) || die "cannot open $wifax_conf\n";
    while (<CONF>) {
	chop;
	/\S/ || next;
	/\s*\#/ && next;
	/\s*([^= ]+)\s*=\s*(.*)$/ || next;
	$1 =~ tr/A-Z/a-z/;
	$CONFIG{$1}=$2;
    }
    close(CONF);
}

# ---------------------------------------------------------------------------
# ѿDEFAULT
# ---------------------------------------------------------------------------
$default_rulefile = "/var/wifax/etc/wifax.rule";
$default_spooldir = "/var/wifax/spool/";
$default_bindir   = "/usr/wide/wifax/bin";

# ---------------------------------------------------------------------------
# PATH
# ---------------------------------------------------------------------------

$rulefile = ($CONFIG{'rulefile'} eq "") ? 
    $default_rulefile : $CONFIG{'rulefile'};
$spooldir = ($CONFIG{'spooldir'} eq "") ? 
    $default_spooldir : $CONFIG{'spooldir'};
$bindir = ($CONFIG{'bindir'} eq "") ? 
    $default_bindir : $CONFIG{'bindir'};

# ---------------------------------------------------------------------------

# ---------------------------------------------------------------------------
# 
# ---------------------------------------------------------------------------

$headerfilename = "header";

#
# Some external commands
#
$CPP = "/usr/libexec/cpp";
$LS   = "/bin/ls";
$FIND = "/usr/bin/find";

#
# Some flags
#
$WIFAX_DISPATCHER_EXTEND_FAXADDR = 1;
$WIFAX_DISPATCHER_EXTEND_MAILADDR = 1;

#
# /var/wifax/etc/wifax.rule
#    ѥ     ư
# Ȥȥѥˤ϶ޤޤʤưʬˤ
# 򤬴ޤޤ⤢롣
# ѥperlɽ
# wifax.rulecpp̤ɾΤǡ̿̾ʤɤ
# ǽdefineƤޤΤ褤
# # cppʤm4ˤۤ褤⡣
# ޤưˤѿǤ
# ѤǤѿ
# %s : ΥץͿ줿ǥ쥯ȥΥե̾
# %F : To: fax-addr 򤭤(see also RFC2304)
# %A : To: 
# %V : ѥ˥ޥå
# %D : ΥץͿ줿ǥ쥯ȥ̾
# 
# e.g. :
# #define IFAX_FAX_SEND /local/bin/ifax_fax_send
# #define IFAX_MAIL_SEND /local/bin/ifax_mail_send
# #define IFAX_PRT_SEND  /local/bin/ifax_prt_send
# #define HTPOST /local/bin/Webpost륳ޥɤȤ
# 
# To    .*kimoto@ifax.ohnolab.org  IFAX_MAIL_SEND -d kimoto-ifax %s
# To    .*@ifax.ohnolab.org        IFAX_FAX_SEND -d %F %s
# From  .*@ifax.sfc.wide.ad.jp     IFAX_PRT_SEND -Ppringles %s
# X-Post http://.*                 HTPOST %v %s

#
# &dispatch($headerfilename)
# :
#  actionʸΥꥹ
# ѿִϤɤޤǤäƤޤ礦

sub dispatch {
    # ϥإåե̾
    ($headfile) = @_;
    local(%confs,%headers,@retlist);

    # ȤͿ줿إåɤ߹
    # ö٤ϢˤƤޤ
    open(HED,$headfile) || die "open header file";
    while (<HED>) {
	chop;
	/\S/ || next; # Ԥ̵
	($key,$val) = (/([^\s:]+)\s*:\s*(.*)/);
	$key =~ tr/A-Z/a-z/;
	$headers{$key} = $val;
    }
    close(HED);

    # եԤɤǤ
    open(CONF,"$CPP $rulefile |") || die "execute cpp and open $rulefile";
    while (<CONF>) {
	chop;
	/\S/ || next; # Ԥ̵
	($key,$regx,$action) = (/^\s*(\S+)\s+(\S+)\s+(.+)/);
	($action =~ /\S/) || next; # actionꤵƤʤä̵

	# 

	$key =~ tr/A-Z/a-z/;	
	if ($headers{$key} =~ /$regx/) {
	    # ѥ˥ޥå

	    # ѥ˥ޥåʸ֤򤹤
	    $action =~ s/%V/$headers{$key}/g;

	    # fax-addr֤Ĥ롩
	    if ($WIFAX_DISPATCHER_EXTEND_FAXADDR != 0 &&
		$action =~ /%F/ ) {
		$to_val = $headers{"to"};
		$telnum = "";
		if ($to_val =~ /([\d\.\-]+)\@/ ||
		    $to_val =~ /\+([\d\.\-]+)\@/ ||
		    $to_val =~ /\/[Ff][Aa][Xx]=\+([\d\.\-]+)\/\@/ ||
		    $to_val =~ /[Ff][Aa][Xx]=\+([\d\.\-]+)\@/) {
		    $telnum = $1;
		} elsif ($to_val =~ /([\d\.\-]+)\/[Tt]33[Ss]=(\d+)\@/ ||
			 $to_val =~ /\+([\d\.\-]+)\/[Tt]33[Ss]=(\d+)\@/ ||
			 $to_val =~ /\/[Ff][Aa][Xx]=\+([\d\.\-]+)\/[Tt]33[Ss]=(\d+)\/\@/ ||
			 $to_val =~ /[Ff][Aa][Xx]=\+([\d\.\-]+)\/[Tt]33[Ss]=(\d+)\@/) {
		    $telnum = $1 . "*" . $2;
		} else {
		    # format error
		}
		$action =~ s/%F/$telnum/g;
	    }

	    # mail-addr֤Ĥ롩
	    if ($WIFAX_DISPATCHER_EXTEND_MAILADDR != 0 &&
		$action =~ /%A/) {
		$to_val = $headers{"to"};
		$action =~ s/%A/$to_val/g;
	    }
	    
	    # ե֤̾ĤϤǤϤǤʤ͡

	    push(@retlist,$action);
	    # ĥޥå齪λ뤫ɤ
	    last;
	}
    }
    close(CONF);
    return @retlist;
}

#
# mainϤ
#
# dispatcher.plϰȤƽоݤȤʤǥ쥯ȥ̾
# Ϳ롣ǥ쥯ȥ̾ϥեѥ
# e.g. dispatcher.pl /var/wifax/spool/10987

$activedir = $ARGV[0];
unless ($activedir =~ /\S/) {
    print "Too fee arguments.\n";
    exit 1;
}

$header = "$activedir/$headerfilename";
@commands = &dispatch($header);
$spoolnum = ($activedir =~ /(\d+)$/)[0];

$flag = 0;

for $command (@commands) {
last if ($flag == 1);
$flag = 1;    
# ǥ쥯ȥ֤̾򤹤
    if ($command =~ /%D/) {
	$command =~ s/%D/$activedir/g;
    }
    
# סֹ֤򤹤  Ϥꤿʤ
    if ($command =~ /%N/) {
	$command =~ s/%N/$spoolnum/g;
    }

#ե̾ΥꥹȤ֤򤹤
    if ($command =~ /%s/) {
	# $flist ˤΥǥ쥯ȥΥեΥꥹȤ
	$flist = "";
	open(FIND,"$FIND $activedir/ ! -type d|") || die "cannot execute ls command";
	while(<FIND>) {
	    chop;
	    $flist .= " $_";
	}
	close(FIND);
	
	$command =~ s/%s/$flist/g;
    }
    
    print "$command\n";
    system($command);
# !!!  ºݤ˼¹ԤϡιԤΥȤ򳰤Ƥ
# !!!
# !!!
}

exit(0);
1;

# 
#   headerηޤ
#   headerβϤȤäƤʤ
#   ʣToȤCcäɤΤ
#   ʣΥѥ˥ޥåνϺΤޤޤǤ褤Τ
#       ʤ褯ʤȻפ
#   default ruleʤɤΤ
#
