#!/usr/bin/perl
# 
# WIDE InternetFAX
#
# file: ifax_setup.pl
# 
# Written by Masahiko KIMOTO <kimoto@ohnolab.org>.
# Copyright (c) 1998 and 1999 by Masahiko KIMOTO <kimoto@ohnolab.org>,
#                       Ohno Laboratory(Tokyo Institute of Technology),
#                       WIDE Project.
# ALL RIGHTS RESERVED.
#
# If you need fully defined copyright notice, see COPYRIGHT which is 
# included in this package.
# 
# $Id: ifax_setup.pl,v 1.11 1999/03/09 04:59:50 kimoto Exp $

# ---------------------------------------------------------------------------
# DESCRIPTION OF THIS FILE:
# WIDE/IFAXåȥåץץ
# ܺ٤README.ifax_setup.jp򻲾ȤΤ
# ---------------------------------------------------------------------------

$GREP    = "/usr/bin/egrep";
$TOUCH   = "/usr/bin/touch";
$MKFIFO  = "/usr/bin/mkfifo";
$ADDUSER = "/usr/sbin/adduser";
$PWD     = "/bin/pwd";
$CHOWN   = "/usr/sbin/chown";
$YES     = "/usr/bin/yes";

$DEFAULTGID=60;
$DEFAULTUID=60;

# ---------------------------------------------------------------------------
# ¹Ը¤Ĵ٤
# ---------------------------------------------------------------------------

# 롼Ȥʤ
($< != 0) && die "Only root can execute this script.\n";
umask(022);

# ---------------------------------------------------------------------------
# group wifax Ĵ٤
# ---------------------------------------------------------------------------

# wifaxȤgroup¸ߤ뤫
# ⤷¸ߤʤä鼫ưŪ˺뤫ɤ䤤碌
#  ⤷ʤΤʤ顢ưǺäƤͤȸäƽ
# wifaxȤgroup

chop($_grp = `$GREP '^wifax:' /etc/group`);
if ($_grp eq "") {
    while(1) {
	print "Wifax group does not exist.\n";
	print "Add it to /etc/group, or exit to do it manualy?(add/exit):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "add");
	exit if ($_rep eq "exit");
    }
    $GID=$DEFAULTGID;
    while(1) {
	chop($_grp = `$GREP $GID /etc/group`);
	last if ($_grp eq "");
	$GID++;
    }
    open(OUT,">>/etc/group") || die "open /etc/group";
    print OUT "wifax:*:$GID:\n";
    close(OUT);
    print "Wifax group was added into /etc/group\n";
} else {
    print "Wifax group already exist.\n";
    $GID=(split(/:/,$_grp))[2];
    if ($GID == 0) {
	print "Invalid GID for wifax\n";
	exit;
    }
}

# ---------------------------------------------------------------------------
# 桼wifaxĴ٤
# ---------------------------------------------------------------------------

# wifax Ȥ̾Υ桼¸ߤ뤫
# ¸ߤʤä鼫ưŪ˺뤫ɤ䤤碌롣
#   ⤷ʤΤʤ顢ưǺäƤͤȸäƽ
# wifaxȤ桼
# home dir

chop($_usr = `$GREP '^wifax:' /etc/passwd`);
if ($_usr eq "") {
    print "Wifax user does not exist.\n";
    if (-x $ADDUSER) {
	while(1) {
	    print "Add it by adduser command or exit to do it manually?(add/exit):";
	    chop($_rep = <STDIN>);
	    last if ($_rep eq "add");
	    exit if ($_rep eq "exit");
	}
	$UID=$DEFAULTUID;
	while(1) {
	    chop($_grp = `$GREP $UID /etc/passwd`);
	    last if ($_grp eq "");
	    $UID++;
	}
	print "Adding user wifax: uid=$UID\n";
	`$YES '' | $ADDUSER -P '*' -u $UID -g wifax -s /bin/sh -G -F WIDE/IFAX wifax `; # XXX
	print "done.\n";
    } else {
	print "Adduser command is unavailable. Please add wifax user manually.\n";
	exit;
    }

} else {
    print "Wifax user already exist.\n";
    $UID=(split(/:/,$_usr))[2];
    if ($UID == 0) {
	print "But invalid uid for wifax.\n";
	exit;
    }
}

chop($_grp = `$GREP '^wifax:' /etc/passwd`);
$WIFAXHOME=(split(/:/,$_grp))[5];
if (! -d $WIFAXHOME) {
    print "Home directory for wifax user does not exist.\n";
    exit;
}

# ---------------------------------------------------------------------------
# ifax_*֤
# ---------------------------------------------------------------------------

# ifax_* μ¹Է֤ʹǥեȤϥȥǥ쥯ȥ

chop($BINDIR=`$PWD`);
while(1) {
    if (-x "$BINDIR/ifax_dispatcher.pl") {
	print "WIDE/IFAX binary directory is being set to $BINDIR\n";
	print "Is this correct?(yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "yes");
	next if ($_rep ne "no");
    }
    print "Enter WIDE/IFAX binary directory: ";
    chop($BINDIR=<STDIN>);
}

# ---------------------------------------------------------------------------
# spoolǥ쥯ȥ
# ---------------------------------------------------------------------------

# spoolǥ쥯ȥɤˤ뤫ʹǥեȤ/var/wifax/spool
# spoolǥ쥯ȥ
# ɬפʥեtouch
# FIFO(/var/wifax/spool/trigger)

$WIFAXDIR="/var/wifax";
while(1) {
    print "WIDE/IFAX working directry is being set to $WIFAXDIR\n";
    if (-d $WIFAXDIR) {
	print "$WIFAXDIR already exist.\n";
	print "Do you wish to use this directory? (yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "yes");
	next if ($_rep ne "no");
    }	
    while(1) {
	print "Please specify path of WIDE/IFAX working directry, or press enter for default.\n";
	print "Please enter: ";
	chop($_rep = <STDIN>);
	last if ($_rep eq "");
	$WIFAXDIR = $_rep;
	last if ($WIFAXDIR =~ /^\//);
	print "Error: Please enter full path.\n";
    }
    last unless (-d $WIFAXDIR);
}

if (! -d "$WIFAXDIR") {
    print "$WIFAXDIR does not exist. Now creating.\n";

    $_dir="";
    foreach $_nx (split(/\//,$WIFAXDIR)) {
	$_dir .= "/$_nx";
	next if (-d $_dir);
	mkdir($_dir,0755);
	`$CHOWN wifax.wifax $_dir`;
    }
}

if (! -d "$WIFAXDIR/spool") {
    mkdir("$WIFAXDIR/spool",0755);
    `$CHOWN wifax.wifax $WIFAXDIR/spool`;

    `$TOUCH $WIFAXDIR/spool/seqf`;
    `$CHOWN wifax.wifax $WIFAXDIR/spool/seqf`;

    `$TOUCH $WIFAXDIR/spool/topf`;
    `$CHOWN wifax.wifax $WIFAXDIR/spool/topf`;

    `$MKFIFO $WIFAXDIR/spool/trigger`;
    `$CHOWN wifax.wifax $WIFAXDIR/spool/trigger`;
}
if (! -d "$WIFAXDIR/etc") {
    mkdir("$WIFAXDIR/etc",0755);
    `$CHOWN wifax.wifax $WIFAXDIR/etc`;
}


# ---------------------------------------------------------------------------
# 롼ǡ١
# ---------------------------------------------------------------------------

# 롼ǡ١եɤ֤ʹǥեȤ
# /var/wifax/etc/wifax.rule
# ɬפʤ饵ץե򥳥ԡ

$RULEFILE = "$WIFAXDIR/etc/wifax.rule";
while (1) { 
    print "Path of rule data base is being set to $RULEFILE.\n";
    if (-f $RULEFILE) {
	print "$RULEFILE already exist.\n";
	print "Do you wish to use this?(yes/no):";
	chop($_rep=<STDIN>);
	last if ($_rep eq "yes");
	next if ($_rep ne "no");
    }
    while(1) {
	print "Please specify path path of rule file, or press enter for default.\n";
	print "Please enter: ";
	chop($_rep = <STDIN>);
	last if ($_rep eq "");
	$RULEFILE = $_rep;
	last if ($RULEFILE =~ /^\//);
	print "Error: Please enter full path.\n";
    }
    last unless (-f $RULEFILE);
}    

# XXX mkdirhier
if (! -f $RULEFILE) {
    open(OUT,">$RULEFILE") || die "open $RULEFILE";
    print OUT " 
#define IFAX_FAX_SEND  $BINDIR/ifax_fax_send
#define IFAX_MAIL_SEND $BINDIR/ifax_mail_send
#define IFAX_PRT_SEND  $BINDIR/ifax_prt_send

/* default rules */

/* To act as an offramp gateway */
To        /fax=.+               IFAX_FAX_SEND -d %F %s
To        fax=.+                IFAX_FAX_SEND -d %F %s

/* To act as an normal fax machine */
X-FromFax .+                    IFAX_MAIL_SEND -d ifax@localhost -s %N

/* To act as an InternetFAX: out going */
X-FromScanner .+                IFAX_MAIL_SEND -d %A %s

/* To act as an InternetFAX: in coming */
To       ifax@.+                IFAX_PRT_SEND -H -Plprt0 -s %N
";
    close OUT;
}

# ---------------------------------------------------------------------------
# .qmailط
# ---------------------------------------------------------------------------

# 顼mail .qmail*-requestȿǤ

# ե뤬¸ߤʤä顢ŬʥץȤ¹Ԥ褦
# .qmail-* 
# Ʊ̾Υե뤬Ǥ¸ߤˤϡƤǧ
# ٹФ

print "Please enter e-mail address of the administrater:";
chop($ADMIN = <STDIN>);

print "Writing administrater's address into .qmal-*-request.\n";

while(1) {
    if (-e "$WIFAXHOME/.qmail") {
	print "Overwrite $WIFAXHOME/.qmail?(yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "no");
	next if ($_rep ne "yes");
    } 
    open(OUT,">$WIFAXHOME/.qmail") || die "open .qmail";
    print OUT "| $BINDIR/ifax_mail_recv\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail`;
    open(OUT,">$WIFAXHOME/.qmail-request") || die "open .qmail-request";
    print OUT "$ADMIN\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-request`;
    last;
}

while(1) {
    if (-e "$WIFAXHOME/.qmail-default") {
	print "Overwrite $WIFAXHOME/.qmail-default?(yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "no");
	next if ($_rep ne "yes");
    } 
    open(OUT,">$WIFAXHOME/.qmail-default") || die "open .qmail-default";
    print OUT "| $BINDIR/ifax_mail_recv\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-default`;
    open(OUT,">$WIFAXHOME/.qmail-default-request")
	|| die "open .qmail-default-request";
    print OUT "$ADMIN\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-default-request`;
    last;
}

while(1){
    if (-e "$WIFAXHOME/.qmail-offramp") {
	print "Overwrite $WIFAXHOME/.qmail-offramp?(yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "no");
	next if ($_rep ne "yes");
    }
    open(OUT,">$WIFAXHOME/.qmail-offramp") || die "open .qmail-offramp";
    print OUT "| $BINDIR/ifax_mail_recv\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-offramp`;
    open(OUT,">$WIFAXHOME/.qmail-offramp-request")
	|| die ".qmail-offramp-request";
    print OUT "$ADMIN\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-offramp-request`;
    last;
}

print "done.\n";

while(1) {
    if (-e "$WIFAXHOME/.qmail-faxrecv") {
	print "Overwrite $WIFAXHOME/.qmail-faxrecv?(yes/no):";
	chop($_rep = <STDIN>);
	last if ($_rep eq "no");
	next if ($_rep ne "yes");
    }
    open(OUT,">$WIFAXHOME/.qmail-faxrecv") || die "open .qmail-recvfax";
    print OUT "| $BINDIR/ifax_fax_recv\n";
    close(OUT); 
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-faxrecv`;
    open(OUT,">$WIFAXHOME/.qmail-faxrecv-request")
	|| die "open .qmail-faxrecv-request";
    print OUT "$ADMIN\n";
    close(OUT);
    `$CHOWN wifax.wifax $WIFAXHOME/.qmail-faxrecv`;
    last;
}

# ---------------------------------------------------------------------------
# qmailŪѹ
# ---------------------------------------------------------------------------

# /var/qmail/users/
# RFC2304б뤿/fax=, fax=ǻϤޤ륢ɥ쥹򤹤٤
# wifax-offramp褦ˤ

if (-e "/var/qmail/users/assign") {
    chop($_grep=`$GREP '^+fax=' /var/qmail/users/assign`);
} else {
    $_grep = "";
}

# XXX
# ºݤΤȤ.qmail-offrampˤϥޥå.qmail-defaultν
# ǤƤ롣
if (! $_grep =~ /\S/) {
    open(OUT,">>/var/qmail/users/assign") || die "open qmail/users/assign";
    print OUT "+fax=:wifax:$UID:$GID:$WIFAXHOME:-:offramp:\n";
    print OUT "+/fax=:wifax:$UID:$GID:$WIFAXHOME:-:offramp:\n";
    print OUT ".\n";
    close(OUT);
    system("/var/qmail/bin/qmail-newu");
    # XXX: error check
}

# ⤷ifax@hostnameǽalias

print "Do you wish to receive fax e-mail messages by ifax@YOURDOMAIN? (yes/no):";
chop($_rep = <STDIN>);

if ($_rep eq "yes") {
    if (-e "/var/qmail/alias/.qmail-ifax") {
	$_grep=`$GREP wifax /var/qmail/alias`;
	if ($_grep ne "wifax") {
	    open(OUT,">>/var/qmail/alias/.qmail-ifax") 
		|| die "open .qmail-ifax";
	    print OUT "wifax\n";
	    close(OUT);
	}
    } else {
	open(OUT,">/var/qmail/alias/.qmail-ifax")
	    || die "open .qmail-ifax";
	print OUT "wifax\n";
	close(OUT);
    }
}

# ---------------------------------------------------------------------------
# FaxMaster  wifax-faxrecv ؤalias
# ---------------------------------------------------------------------------

open(OUT,">>/var/qmail/alias/.qmail-FaxMaster")
    || die "open .qmail-FaxMaster";
# ifax_fax_recvޤpollingʤΤǡϤȤꤢʤ褦ˤƤ
# print OUT "wifax-faxrecv\n"; # XXX
close(OUT);

# ---------------------------------------------------------------------------
# /etc/wifax.conf ؤν񤭽Ф
# ---------------------------------------------------------------------------

print "Writing /etc/wifax.conf\n";
open(OUT,">/etc/wifax.conf") || die "open /etc/wifax.conf";
print OUT "rullefile = $RULEFILE\n";
print OUT "spooldir = $WIFAXDIR/spool\n";
print OUT "bindir = $BINDIR\n";
close(OUT);
print "done\n";

# ---------------------------------------------------------------------------
# /etc/rc.local or /etc/rc.userؤν񤭽Ф
# ---------------------------------------------------------------------------

# currently we do nothing here.

# ---------------------------------------------------------------------------
# End of Program
# ---------------------------------------------------------------------------

print "\nSetting up WIDE/IFAX system is done.\n";
exit;
