Specification of ifax_dispatcher.pl(module K)

Program name:
	ifax_dispatcher.pl

Argument:
	A path of a spool directory to handle.

	e.g.: ifax_dispatcher.pl /var/wifax/spool/235

Behavior:
	"ifax_dispatcher.pl"(the dispatcher from now on) refers to contents
	in a header file(file name: "header") just under a given spool
	directory and, basing on the rule database(described below), runs
	a sending submodule of WIDE/IFAX.

	A format of a header file is based on RFC 822. An e-mail header
	is stored as it is if contents of a spool directory are generated
	from the e-mail message, or an appropriate item is stored if a
	spool directory is generated from FAX etc. As for a header file,
	refer to the specification of a spool format.

	The dispatcher reads all contents in the rule database at first.
	And then it evaluates the header file from the first. If the header
	matches for the rule, the dispatcher adds a submodule to run to
	the list.

	After the dispatcher has read through the header file, it
	sequentially evaluates the list of the submodules to run.
	It expands the specified argument and runs one after another.

	The dispatcher only refers to a header file in the spool directory,
	never makes any change on the header file nor files in other spools.

Configuration File:
	The dispatcher, depending on the rule database, allocates a message.
	The regular place to put the rule database in is
		/var/wifax/etc/wifax.rule
	The dispatcher puts the configuration file(wifax.rule from now on)
	through cpp(see also cpp(1)) when evaluating it. So you can use
	comments and macro definitions which are available for cpp in
	wifax.rule.

	One rule is written per one line in wifax.rule.
	The format is as follows.

	key	pattern		action

	The separater between each item is a set of space or tab characters.
	You can not use a space in "key" nor "pattern", while you can in
	"action".

	The "pattern" is a regular expression. This is the same one in perl.

	When the "key" matches for the "pattern", the "action" is done.	
	The former line has the higher priority. If one rule has hit,
	the evaluation is over. This is, only the firstly hit rule is valid.

	What to run is written in the "action". In this field, you can use
	variables beginning "%". The variables are expanded as follow.

	   %s : a list of files in the spool directory given as the argument
	   %F : a telephone number for G3FAX extracted from a "To" field
	        in the header file (see also RFC 2304)
	   %A : a value of "To" field in the header file
	   %V : a value matching for the pattern
	   %D : a name of the spool directory given to this program

	It is recommended that normally you should declare the instructions
	specified in the "action" as macros at the top of wifax.rule.
	
	   e.g. :
	      #define IFAX_FAX_SEND /local/bin/ifax_fax_send
	      #define IFAX_MAIL_SEND /local/bin/ifax_mail_send
	      #define IFAX_PRT_SEND  /local/bin/ifax_prt_send
	      #define HTPOST command to post to Web, etc.


Sample for Configuration File:

---------------------------------------------------------------------------
#define IFAX_FAX_SEND /usr/wide/wifax/bin/ifax_fax_send
#define IFAX_MAIL_SEND /usr/wide/wifax/bin/ifax_mail_send
#define IFAX_PRT_SEND  /usr/wide/wifax/bin/ifax_prt_send


/* special actions */
To    .*@ifax.your.domain	IFAX_MAIL_SEND -d foo-faxbox %D
To    .*@ifax.your.domain	IFAX_FAX_SEND -d %F %s
From  .*@ifax.friend.domain	IFAX_PRT_SEND -Pprinter0 %s
X-Post http://.*                HTPOST %v %s
X-TSI  0312345678               IFAX_MAIL_SEND -d your-labo@your.domain

/* default rules */

/* To act as an offramp gateway */
To        /fax=.+               IFAX_FAX_SEND -d %F %s
To        fax=.+                IFAX_FAX_SEND -d %F %s

/* To act as an normal fax machine */
X-FromFax .+                    IFAX_PRT_SEND -Pprinter1 -s %N

/* To act as an InternetFAX: out going */
X-FromScanner .+                IFAX_MAIL_SEND -d %A %s

/* To act as an InternetFAX: in coming */
To       ifax@.+                IFAX_PRT_SEND -Pprinter2 -s %N
---------------------------------------------------------------------------

Error Handling:
	When no rule has hit:
		Sends an error mail to an appropriate address depending
		on the contents of the header file. Or sends an error
		mail to the administrator who installed WIDE/IFAX if
		an appropriate address is not found.

	When the sending submodule has abnormally exited:
		Ends after returning the exit code of the submodule.

Exit Code:
	Returns 0 if normally ended.
	Returns 1000 if no argument is specified and exits.
	Returns 2000 if no rule has been hit and exits.
	Returns an exit code returned by a sending submodule if the
	submodule has abnormally exited.

Log File:
	The dispatcher outputs an appropriate log. The log includes a date
	when the dispatcher was started, the spool directory, the executed
	submodule, the exit code, etc.

Problems:
	Can't handle what may match for multiple rules and should be
	differently evaluated, like "To" field or "Cc" field.
	  e.g. : when to process each address in "To" field

	Can't write a default rule in wifax.rule.

	Not determined are where and how to put a log file.

	Specified exit code is not returned in some cases.

Author:
	Masahiko Kimoto <kimoto@ohnolab.org>
	  Latest version: $Author: ninomiya $

Last Modification:
	$Date: 1999/03/08 12:32:25 $

----
$Id: README.ifax_dispatcher.pl,v 1.2 1999/03/08 12:32:25 ninomiya Exp $
